<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Showcase
 */

namespace Application\Showcase\Updates;

use Doctrine\DBAL\Schema\Schema;
use Updates\SchemaUpdate;

class Update69 extends SchemaUpdate
{
    protected function prepareSchema(Schema $schema)
    {
        $orders_table = $schema->getTable('pongho_orders');

        $orders_table->addColumn('invoice_province_id', 'integer', ['unsigned' => true, 'notnull' => false]);

        $orders_table->addForeignKeyConstraint(
            $schema->getTable('pongho_provinces'),
            ['invoice_province_id'],
            ['id'],
            ['onDelete' => 'SET NULL']
        );

        $orders_table->addColumn('shipping_province_id', 'integer', ['unsigned' => true, 'notnull' => false]);

        $orders_table->addForeignKeyConstraint(
            $schema->getTable('pongho_provinces'),
            ['shipping_province_id'],
            ['id'],
            ['onDelete' => 'SET NULL']
        );
    }
}
