<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Showcase
 */

namespace Application\Showcase\Updates;

use Doctrine\DBAL\Schema\Schema;
use Updates\SchemaUpdate;

/**
 * Update68.
 *
 * Aggiunge la colonna `pongho_orders`.`is_guest`
 */
class Update68 extends SchemaUpdate
{
    /**
     * {@inheritdoc}
     */
    protected function prepareSchema(Schema $schema)
    {
        $orders_table = $schema->getTable('pongho_orders');

        $orders_table->addColumn('customer_is_guest', 'boolean');
        $orders_table->addColumn('customer_email', 'text', ['length' => 255]);
    }
}
