<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Showcase
 */

namespace Application\Showcase\Updates;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\DBAL\Types\Type;
use Updates\SchemaUpdate;

class Update64 extends SchemaUpdate
{
    /**
     * {@inheritdoc}
     */
    protected function prepareSchema(Schema $schema)
    {
        $discount_conditions_table = $schema->getTable('pongho_orders_discounts_conditions');

        $discount_conditions_table->changeColumn(
            'value',
            ['type' => Type::getType('decimal'), 'precision' => 12, 'scale' => 4]
        );

        $discount_conditions_table->changeColumn(
            'condition',
            ['type' => Type::getType('decimal'), 'precision' => 12, 'scale' => 4]
        );
    }
}
