<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Showcase
 */

namespace Application\Showcase\Updates;

use Doctrine\DBAL\Schema\Schema;
use Updates\SchemaUpdate;

class Update62 extends SchemaUpdate
{
    /**
     * {@inheritdoc}
     */
    protected function prepareSchema(Schema $schema)
    {
        $users_table = $schema->getTable('pongho_users');
        $orders_table = $schema->getTable('pongho_orders');

        if (!$users_table->hasColumn('shipping_address_id')) {
            $users_table->addColumn('shipping_address_id', 'integer', ['unsigned' => true, 'notnull' => false]);

            $users_table->addForeignKeyConstraint(
                $schema->getTable('pongho_addresses'),
                ['shipping_address_id'],
                ['id'],
                ['onDelete' => 'SET NULL']
            );
        }

        if ($orders_table->hasColumn('invoice_address_id')) {
            foreach ($orders_table->getForeignKeys() as $foreign_key) {
                $columns = $foreign_key->getColumns();
                if ($columns[0] === 'invoice_address_id') {
                    $orders_table->removeForeignKey($foreign_key->getName());
                }
            }

            $orders_table->dropColumn('invoice_address_id');
        }
    }
}
