<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Showcase
 */

namespace Application\Showcase\Updates;

use Application\Core\Model\Site;
use Application\Core\Model\Translation;
use Updates\BaseUpdate;

class Update55 extends BaseUpdate
{
    /**
     * {@inheritdoc}
     */
    public function commit()
    {
        Translation::deleteTranslation('discount_settings');
        Translation::deleteTranslation('enable_offers');
        Translation::deleteTranslation('enable_coupons');

        Translation::putTranslation('orders_email', 'Email ordini', 'showcase', 'it_IT');
        Translation::putTranslation('product_discount', 'Sconti su prodotto', 'showcase', 'it_IT');
        Translation::putTranslation('enable_product_discount', 'Abilita le offerte sui prodotti', 'showcase', 'it_IT');
        Translation::putTranslation('order_discount', 'Sconti su ordine', 'showcase', 'it_IT');
        Translation::putTranslation('order_coupon_discount', 'Buono sconto', 'showcase', 'it_IT');
        Translation::putTranslation('order_amount_discount', 'Sconti su importo', 'showcase', 'it_IT');

        Translation::putTranslation('permit_shop.coupons', 'Può gestire i buoni sconto', 'showcase', 'it_IT');
        Translation::putTranslation('permit_shop.orders', 'Può gestire gli ordini', 'showcase', 'it_IT');
        Translation::putTranslation('permit_shop.orders_amount_discount', 'Può gestire gli sconti in base all’importo degli ordini', 'showcase', 'it_IT');
        Translation::putTranslation('permit_shop.payments', 'Può gestire i pagamenti', 'showcase', 'it_IT');
        Translation::putTranslation('permit_shop.shippings', 'Può gestire i trasporti', 'showcase', 'it_IT');
        Translation::putTranslation('permit_shop.sizes', 'Può gestire i tipi di taglia', 'showcase', 'it_IT');
        Translation::putTranslation('permit_shop.stats', 'Può visualizzare le statistiche', 'showcase', 'it_IT');

        Translation::putTranslation('modules_order_amount_discount', 'Sconti sugli ordini', 'showcase', 'it_IT');
        Translation::putTranslation('modules_order_amount_discount_title', 'Gestione sconti in base all’importo dell’ordine', 'showcase', 'it_IT');

        Translation::putTranslation('order_amount_discount_label_fixed', 'Sconto', 'showcase', 'it_IT');
        Translation::putTranslation('order_amount_discount_label_percent', 'Sconto (%s)', 'showcase', 'it_IT');

        /** @var \Application\Core\Model\Site $site */
        foreach (Site::all() as $site) {
            if ($site->getOption('enable_coupons') === true) {
                $site->setOption('order_discount_type', 'coupon_code');
                $site->setOption('enable_coupons', false);
                $site->save();
            }
        }
    }
}
