<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Showcase
 */

namespace Application\Showcase\Updates;

use Doctrine\DBAL\Schema\Schema;
use Updates\SchemaUpdate;

/**
 * Update51.
 *
 * Sconti sugli ordini, fase 1: aggiungo le nuove tabelle.
 */
class Update51 extends SchemaUpdate
{
    /**
     * {@inheritdoc}
     */
    protected function prepareSchema(Schema $schema)
    {
        $ordersTable = $schema->getTable('pongho_orders');
        $ordersTable->addColumn('discount_id', 'integer', ['unsigned' => true, 'notnull' => false]);
        $ordersTable->addColumn('discount_name', 'string', ['length' => 255]);
        $ordersTable->addColumn('discount_value', 'decimal', ['precision' => 12, 'scale' => 4]);

        $discountTable = $schema->createTable('pongho_orders_discounts');
        $discountTable->addColumn('id', 'integer', ['unsigned' => true, 'autoincrement' => true]);
        $discountTable->addColumn('handler_name', 'string', ['length' => 255]);
        $discountTable->addColumn('code', 'string', ['length' => 255]);
        $discountTable->addColumn('expire_on', 'date');
        $discountTable->setPrimaryKey(['id']);

        $discountConditionsTable = $schema->createTable('pongho_orders_discounts_conditions');
        $discountConditionsTable->addColumn('id', 'integer', ['unsigned' => true, 'autoincrement' => true]);
        $discountConditionsTable->addColumn('discount_id', 'integer', ['unsigned' => true, 'notnull' => false]);
        $discountConditionsTable->addColumn('value', 'decimal', ['precision' => 12, 'scale' => 4]);
        $discountConditionsTable->addColumn('value_type', 'string', ['length' => 1]);
        $discountConditionsTable->addColumn('condition', 'decimal', ['precision' => 12, 'scale' => 4]);
        $discountConditionsTable->setPrimaryKey(['id']);

        $ordersTable->addForeignKeyConstraint(
            $discountTable,
            ['discount_id'],
            ['id']
        );

        $discountConditionsTable->addForeignKeyConstraint(
            $discountTable,
            ['discount_id'],
            ['id']
        );
    }
}
