<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Showcase
 */

namespace Application\Showcase\Updates;

use Application\Core\Model\Translation;
use Updates\BaseUpdate;

/**
 * Update44.
 *
 * Aggiunge le traduzioni per le taglie personalizzate.
 */
class Update44 extends BaseUpdate
{
    /**
     * {@inheritdoc}
     */
    public function commit()
    {
        Translation::putTranslation(
            'select_size_type_or_custom',
            'Seleziona il tipo di taglia oppure %saggiungi una taglia personalizzata%s',
            'showcase',
            'it_IT'
        );

        Translation::putTranslation(
            'custom_sizes',
            'Taglie personalizzate',
            'showcase',
            'it_IT'
        );
    }
}
