<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Showcase
 */

namespace Application\Showcase\Updates;

use Application\Core\Installer\Helper\DatabaseSchemaHelper;
use Doctrine\DBAL\Schema\Schema;
use Updates\BaseUpdate;

/**
 * Update212
 *
 * Aggiunge il campo per escludere un prodotto dagli sconti sul totale dell’ordine.
 */
final class Update212 extends BaseUpdate
{
    public function commit()
    {
        (new DatabaseSchemaHelper($this->connection))->update(function (Schema $schema): void {
            $nodesTable = $schema->getTable('pongho_nodes');
            if (!$nodesTable->hasColumn('exclude_from_order_amount_discount')) {
                $nodesTable->addColumn('exclude_from_order_amount_discount', 'boolean', ['default' => false]);
            }
        });
    }
}
