<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Showcase
 */

namespace Application\Showcase\Updates;

use Application\Core\Installer\Helper\DatabaseSchemaHelper;
use Doctrine\DBAL\Schema\Schema;
use Updates\BaseUpdate;

class Update206 extends BaseUpdate
{
    public function commit()
    {
        (new DatabaseSchemaHelper($this->connection))->update(function (Schema $schema): void {
            $sizesTable = $schema->getTable('pongho_nodes_sizes');
            foreach (['price', 'offer', 'weight'] as $columnName) {
                $sizesTable->changeColumn(
                    $columnName,
                    [
                        'unsigned'  => true,
                        'precision' => 12,
                        'scale'     => 4,
                        'default'   => 0,
                    ]
                );
            }

            $nodesTable = $schema->getTable('pongho_nodes');
            foreach (['price', 'offer', 'discount'] as $columnName) {
                $nodesTable->changeColumn(
                    $columnName,
                    [
                        'unsigned'  => true,
                        'precision' => 12,
                        'scale'     => 4,
                        'default'   => 0,
                    ]
                );
            }
        });
    }
}
