<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Showcase
 */

namespace Application\Showcase\Updates;

use Application\Core\Installer\Helper\DatabaseSchemaHelper;
use Application\Core\Installer\Helper\TranslationsHelper;
use Doctrine\DBAL\Schema\Schema;
use Updates\BaseUpdate;

/**
 * Update196
 *
 * Modifiche ai buoni sconto
 */
class Update196 extends BaseUpdate
{
    public function commit()
    {
        (new DatabaseSchemaHelper($this->connection))->update(function (Schema $schema): void {
            $shopOrderDiscountsTable = $schema->getTable('pongho_shop_order_discounts');

            if (!$shopOrderDiscountsTable->hasColumn('description')) {
                $shopOrderDiscountsTable->addColumn('description', 'string', ['length' => 255, 'default' => '']);
            }

            if (!$shopOrderDiscountsTable->hasColumn('valid_from')) {
                $shopOrderDiscountsTable->addColumn('valid_from', 'datetime', ['notnull' => false, 'default' => null]);
            }

            if (!$shopOrderDiscountsTable->hasColumn('settings')) {
                $shopOrderDiscountsTable->addColumn('settings', 'json_array', ['notnull' => false, 'default' => '']);
            }

            if (!$shopOrderDiscountsTable->hasColumn('email_sender_name')) {
                $shopOrderDiscountsTable->addColumn('email_sender_name', 'string', ['length' => 255, 'default' => '']);
            }

            if (!$shopOrderDiscountsTable->hasColumn('email_sender_email')) {
                $shopOrderDiscountsTable->addColumn('email_sender_email', 'string', ['length' => 255, 'default' => '']);
            }

            if (!$shopOrderDiscountsTable->hasColumn('email_subject')) {
                $shopOrderDiscountsTable->addColumn('email_subject', 'string', ['length' => 255, 'default' => '']);
            }

            if (!$shopOrderDiscountsTable->hasColumn('email_body')) {
                $shopOrderDiscountsTable->addColumn('email_body', 'text', ['length' => 65535, 'default' => '']);
            }

            if (!$shopOrderDiscountsTable->hasColumn('email_sent')) {
                $shopOrderDiscountsTable->addColumn('email_sent', 'boolean', ['default' => false]);
            }
        });

        (new TranslationsHelper($this->connection))
            ->setCulture('it_IT')
            ->addTranslation('coupon_error_not_valid', 'Il buono sconto inserito non è valido.', 'showcase')
            ->changeTranslation('coupon_label_percent', 'Buono sconto (%s%%)')
        ;
    }
}
