<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Showcase
 */

namespace Application\Showcase\Updates;

use Application\Core\Installer\Helper\TranslationsHelper;
use Updates\BaseUpdate;

/**
 * Update188
 *
 * Corregge le traduzioni.
 */
class Update188 extends BaseUpdate
{
    public function commit()
    {
        $helper = new TranslationsHelper($this->connection);
        $helper->setCulture('it_IT');

        $translations = [
            'cart_updated'                    => 'Il carrello è stato aggiornato!',
            'cart_has_previous_rows'          => 'I prodotti evidenziati sono stati aggiunti al carrello nelle visite precedenti.',
            'cart_has_unavailable_rows'       => 'I prodotti evidenziati non sono più disponibili e la loro quantità è stata impostata a zero.',
            'cart_row_not_added'              => 'Un problema ha impedito l’aggiunta del prodotto al carrello!',
            'size_not_available'              => 'La taglia selezionata non è disponibile.',
            'cart_row_not_deleted'            => 'Un problema ha impedito la rimozione del prodotto!',
            'cart_row_deleted'                => 'Prodotto eliminato dal carrello!',
            'cart_emptied'                    => 'Il carrello è stato svuotato!',
            'page_title_addresses'            => 'Gestione indirizzi',
            'page_title_login'                => 'Accedi',
            'email_shop_payment_fail_subject' => 'Pagamento fallito',
        ];

        foreach ($translations as $key => $value) {
            $helper->addTranslation($key, $value, 'showcase');
        }

        $page_titles = [
            [
                'old_key' => 'cart',
                'new_key' => 'page_title_cart',
                'value'   => 'Carrello',
            ],
            [
                'old_key' => 'checkout',
                'new_key' => 'page_title_checkout',
                'value'   => 'Checkout',
            ],
            [
                'old_key' => 'ticket',
                'new_key' => 'page_title_ticket',
                'value'   => 'Scontrino',
            ],
            [
                'old_key' => 'user_order_title',
                'new_key' => 'page_title_order',
                'value'   => 'Ordine n° %s del %s',
            ],
            [
                'old_key' => 'user_orders_title',
                'new_key' => 'page_title_orders',
                'value'   => 'I miei ordini',
            ],
        ];

        foreach ($page_titles as $translation) {
            $helper->copyOrAdd($translation['old_key'], $translation['new_key'], $translation['value'], 'showcase');
        }
    }
}
