<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Showcase
 */

namespace Application\Showcase\Updates;

use Doctrine\DBAL\Schema\Schema;
use Updates\SchemaUpdate;

/**
 * Update159
 *
 * Modifiche allo schema del database per la raccolta punti.
 */
class Update159 extends SchemaUpdate
{
    /**
     * {@inheritdoc}
     */
    protected function prepareSchema(Schema $schema)
    {
        $users_table = $schema->getTable('pongho_users');
        $orders_table = $schema->getTable('pongho_orders');

        $column_options = ['notnull' => false, 'default' => 0, 'unsigned' => true];

        if (!$users_table->hasColumn('shopping_points')) {
            $users_table->addColumn('shopping_points', 'integer', $column_options);
        }

        if (!$orders_table->hasColumn('shopping_points')) {
            $orders_table->addColumn('shopping_points', 'integer', $column_options);
        }

        if (!$orders_table->hasColumn('used_shopping_points')) {
            $orders_table->addColumn('used_shopping_points', 'integer', $column_options);
        }

        $orders_discounts_table = $schema->getTable('pongho_orders_discounts');
        $orders_discounts_table->changeColumn('expire_on', ['notnull' => false, 'default' => null]);
    }
}
