<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Showcase
 */

namespace Application\Showcase\Updates;

use Doctrine\DBAL\Schema\Schema;
use Updates\SchemaUpdate;

class Update157 extends SchemaUpdate
{
    /**
     * {@inheritdoc}
     */
    protected function prepareSchema(Schema $schema)
    {
        $nodes_table = $schema->getTable('pongho_nodes');
        $terms_table = $schema->getTable('pongho_terms');
        $nodes_sizes_table = $schema->getTable('pongho_nodes_sizes');

        if (!$terms_table->hasColumn('gs_category')) {
            $terms_table->addColumn('gs_category', 'string', ['default' => '', 'length' => 400]);
        }

        if (!$nodes_sizes_table->hasColumn('gtin')) {
            $nodes_sizes_table->addColumn('gtin', 'string', ['default' => '', 'length' => 20]);
        }

        if (!$nodes_sizes_table->hasColumn('mpn')) {
            $nodes_sizes_table->addColumn('mpn', 'string', ['default' => '', 'length' => 50]);
        }

        if (!$nodes_sizes_table->hasColumn('gs_enabled')) {
            $nodes_sizes_table->addColumn('gs_enabled', 'boolean', ['default' => false]);
        }

        if (!$nodes_sizes_table->hasColumn('gs_type')) {
            $nodes_sizes_table->addColumn('gs_type', 'string', ['default' => '', 'length' => 20]);
        }

        if (!$nodes_table->hasColumn('gs_color')) {
            $nodes_table->addColumn('gs_color', 'string', ['default' => '', 'length' => 255]);
        }

        if (!$nodes_table->hasColumn('gs_gender')) {
            $nodes_table->addColumn('gs_gender', 'string', ['default' => '', 'length' => 20]);
        }

        if (!$nodes_table->hasColumn('gs_age_group')) {
            $nodes_table->addColumn('gs_age_group', 'string', ['default' => '', 'length' => 20]);
        }

        if (!$nodes_table->hasColumn('gs_material')) {
            $nodes_table->addColumn('gs_material', 'string', ['default' => '', 'length' => 255]);
        }

        if (!$nodes_table->hasColumn('gs_pattern')) {
            $nodes_table->addColumn('gs_pattern', 'string', ['default' => '', 'length' => 255]);
        }
    }
}
