<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Showcase
 */

namespace Application\Showcase\Updates;

use Doctrine\DBAL\Schema\Schema;
use Updates\SchemaUpdate;

/**
 * Update152
 *
 * Rimuove la relazione straniera su pongho_orders_rows.row_id
 */
class Update152 extends SchemaUpdate
{
    /**
     * {@inheritdoc}
     */
    protected function prepareSchema(Schema $schema)
    {
        $rows_table = $schema->getTable('pongho_orders_rows');

        if ($rows_table->hasColumn('row_id')) {
            foreach ($rows_table->getForeignKeys() as $foreign_key) {
                $columns = $foreign_key->getColumns();
                if ($columns[0] === 'row_id') {
                    $rows_table->removeForeignKey($foreign_key->getName());
                }
            }
        }
    }
}
