<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Showcase
 */

namespace Application\Showcase\Updates;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\DBAL\Types\Type;
use Updates\SchemaUpdate;

class Update101 extends SchemaUpdate
{
    /**
     * {@inheritdoc}
     */
    protected function prepareSchema(Schema $schema)
    {
        $orders_table = $schema->getTable('pongho_orders');
        $orders_table->changeColumn(
            'discount_value',
            ['type' => Type::getType('decimal'), 'precision' => 12, 'scale' => 4]
        );
    }
}
