<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Showcase
 */

namespace Application\Showcase\Updates\Model;

use ActiveRecord\Base;

/**
 * Order.
 *
 * Questo modello è utilizzato esclusivamente dall'update 52.
 *
 * @property int                             $discount_id
 * @property string                          $discount_name
 * @property float                           $discount_value
 * @property int                             $site_id
 * @property int                             $coupon_id
 * @property float                           $coupon_discount
 * @property string                          $coupon_discount_type
 * @property float                           $coupon_discount_value
 * @property \Application\Core\Model\Account $customer
 */
class Order extends Base
{
    public static $table_name = 'orders';

    public static $belongs_to = [
        ['customer', 'model' => \Application\Core\Model\Account::class],
    ];
}
