<?php
/**
 * @var \Application\Core\I18n\Translation\Translator $translator
 * @var string                                       $action_form
 * @var string                                       $title
 * @var bool                                         $size_guide_enabled
 * @var string                                       $sizes
 */
?><form action="<?php echo $action_form; ?>" method="post" class="section" id="sizes-form">

	<h2><?php echo $title; ?></h2>

	<?php include 'messages.php' ?>

	<fieldset class="panel">
		<dl class="extend <?php echo $class_title; ?>">
			<dt><label for="title"><?php echo $translator->trans('Title'); ?></label></dt>
			<dd><?php echo $field_title; ?></dd>
		</dl>
		<?php if ($size_guide_enabled): ?>
		<dl class="extend">
			<dt><?php echo $translator->trans('Help page'); ?></dt>
			<dd class="small"><?php echo $field_node_id; ?></dd>
		</dl>
		<?php endif; ?>
	</fieldset>

	<fieldset class="panel">
		<div class="btn">
			<input type="button" name="add" class="add-item" value="<?php echo $translator->trans('Add size'); ?>" />
		</div>

		<?php echo $sizes; ?>
	</fieldset>

	<fieldset class="btn">
		<input type="submit" name="submit" value="<?php echo $translator->trans('Save'); ?>" class="primary" />
	</fieldset>

</form><!-- .section -->
