<?php

/**
 * @var \Application\Core\I18n\Translation\Translator $translator
 * @var string                                        $action_form
 *
 * @var string                                        $value_orders_email
 * @var bool                                          $value_enable_orders_export
 *
 * @var bool                                          $value_enable_offers
 * @var array                                         $value_order_discounts
 * @var array                                         $order_discounts
 *
 * @var int                                           $value_shopping_point_cost
 * @var int                                           $value_shopping_point_value
 * @var int                                           $value_shopping_point_min_points
 * @var int                                           $value_shopping_point_min_total_order
 * @var bool                                          $value_shopping_point_on_single_product
 * @var bool                                          $value_shopping_point_calculate_on_subtotal
 *
 * @var bool                                          $value_enable_order_note
 * @var bool                                          $value_enable_guest_checkout
 *
 * @var bool                                          $value_enable_tax
 * @var string                                        $value_tax_value
 * @var string                                        $value_tax_name
 *
 * @var bool                                          $value_enable_google_shopping
 */

?>
<form action="<?= $action_form; ?>" method="post" class="section">

    <h2><?= $translator->trans('Options'); ?></h2>

    <?php include 'messages.php'; ?>

    <fieldset class="panel">
        <dl class="extend">
            <dt><label for="field-orders-email"><?= $translator->trans('Orders email'); ?></label></dt>
            <dd><input type="text" name="options[orders_email]" id="field-orders-email" value="<?= $value_orders_email; ?>" class="input_text"></dd>
        </dl>
        <dl class="extend">
            <dt><?= $translator->trans('Orders options'); ?></dt>
			<dd>
				<label>
					<input type="checkbox" name="options[enable_orders_export]"<?= $value_enable_orders_export ? ' checked="checked"' : ''; ?>>
					<span><?= $translator->trans('Enable orders export'); ?></span>
				</label>
			</dd>
        </dl>
    </fieldset>

    <fieldset class="panel">
        <h3><?= $translator->trans('Product discounts'); ?></h3>
        <dl class="extend">
            <dt><?= $translator->trans('Discounts on the product'); ?></dt>
            <dd>
                <label>
                    <input type="checkbox" name="options[enable_offers]"<?= $value_enable_offers ? ' checked="checked"' : ''; ?>>
                    <span><?= $translator->trans('Enable the discounts on the products'); ?></span>
                </label>
            </dd>
        </dl>
    </fieldset>

    <fieldset class="panel">
        <h3><?= $translator->trans('Order discounts'); ?></h3>
        <table class="pongho-table">
            <thead>
            <tr>
                <th class="ckb"></th>
                <th class="main"><?= $translator->trans('Order discount'); ?></th>
                <th><?= $translator->trans('Priority'); ?></th>
            </tr>
            </thead>
            <tbody>
            <?php

            $i = 1;
            foreach ($order_discounts as $discountName => $discountLabel):

            ?>
                <tr>
                    <td class="ckb">
                        <input type="checkbox" name="options[order_discounts][<?= $discountName; ?>][is_enabled]" value="1" id="order-discount-<?= $discountName; ?>"<?= in_array($discountName, $value_order_discounts) ? ' checked' : ''?>>
                    </td>
                    <td class="main">
                        <label for="order-discount-<?= $discountName; ?>"><?= $discountLabel; ?></label>
                    </td>
                    <td class="smallest">
                        <input type="number" name="options[order_discounts][<?= $discountName; ?>][priority]" class="input_text" value="<?= $i++; ?>">
                    </td>
                </tr>
            <?php endforeach; ?>
            </tbody>
        </table>
    </fieldset>

    <fieldset class="panel" id="shopping-points"<?= in_array('shopping_points', $value_order_discounts) ? '' : ' style="display: none;"'; ?>>
        <dl class="extend">
            <dt><?= $translator->trans('Shopping points'); ?></dt>
            <dd class="smallest">
                <label>
                    <input type="text" name="options[shopping_point_cost]" value="<?= $value_shopping_point_cost; ?>" class="input_text">
                    <span><?= $translator->trans('Cost of a point'); ?></span>
                </label>
            </dd>
            <dd class="smallest">
                <label>
                    <input type="text" name="options[shopping_point_value]" value="<?= $value_shopping_point_value; ?>" class="input_text">
                    <span><?= $translator->trans('Value of a point'); ?></span>
                </label>
            </dd>
            <dd class="smallest">
                <label>
                    <input type="text" name="options[shopping_point_min_points]" value="<?= $value_shopping_point_min_points; ?>" class="input_text">
                    <span><?= $translator->trans('Minimum number of points to use them'); ?></span>
                </label>
            </dd>
            <dd class="smallest">
                <label>
                    <input type="text" name="options[shopping_point_min_total_order]" value="<?= $value_shopping_point_min_total_order; ?>" class="input_text">
                    <span><?= $translator->trans('Minimum total of the order to use the points'); ?></span>
                </label>
            </dd>
            <dd>
                <label>
                    <input type="checkbox" name="options[shopping_point_on_single_product]"<?= $value_shopping_point_on_single_product ? ' checked="checked"' : ''; ?>>
                    <span><?= $translator->trans('Set a specific amount of points for each product / size'); ?></span>
                </label>
            </dd>
            <dd id="coupons">
                <label>
                    <input type="checkbox" name="options[shopping_point_calculate_on_subtotal]"<?= $value_shopping_point_calculate_on_subtotal ? ' checked="checked"' : ''; ?>>
                    <span><?= $translator->trans('If other discounts are applied to the order, calculates the points on the discounted amount'); ?></span>
                </label>
            </dd>
        </dl>
    </fieldset>

    <fieldset class="panel">
        <dl class="extend">
            <dt><?= $translator->trans('Checkout'); ?></dt>
            <dd>
                <label>
                    <input type="checkbox" name="options[enable_guest_checkout]"<?= $value_enable_guest_checkout ? ' checked="checked"' : ''; ?>>
                    <span><?= $translator->trans('Enable checkout by the Guest account'); ?></span>
                </label>
            </dd>
            <dd>
                <label>
                    <input type="checkbox" name="options[enable_order_note]"<?= $value_enable_order_note ? ' checked="checked"' : ''; ?>>
                    <span><?= $translator->trans('Enable the notes in the order'); ?></span>
                </label>
            </dd>
        </dl>
    </fieldset>

    <fieldset class="panel">
        <dl class="extend">
            <dt><?= $translator->trans('Tax') ?></dt>
            <dd>
                <label>
                    <input type="checkbox" name="options[enable_tax]"<?= $value_enable_tax ? ' checked="checked"' : ''; ?>>
                    <span><?= $translator->trans('Enable taxation'); ?></span>
                </label>
            </dd>
            <dd class="smallest">
                <label>
                    <input type="text" name="options[tax_value]" value="<?= $value_tax_value; ?>" class="input_text">
                    <span><?= $translator->trans('Percentage value'); ?></span>
                </label>
            </dd>
            <dd>
                <label>
                    <input type="text" name="options[tax_name]" value="<?= $value_tax_name; ?>" class="input_text">
                    <span><?= $translator->trans('Name'); ?></span>
                </label>
            </dd>
        </dl>
    </fieldset>

    <fieldset class="panel">
        <dl class="extend">
            <dt><?= $translator->trans('Google Shopping'); ?></dt>
            <dd>
                <label>
                    <input type="checkbox" name="options[enable_google_shopping]"<?= $value_enable_google_shopping ? ' checked="checked"' : ''; ?>>
                    <span><?= $translator->trans('Enable Google Shopping'); ?></span>
                </label>
            </dd>
        </dl>
    </fieldset>

    <fieldset class="btn">
        <input type="submit" value="<?= $translator->trans('Save'); ?>" class="primary"/>
    </fieldset>

</form><!-- .section -->
