<?php

/**
 * @var \Application\Core\Localization                                         $lang
 * @var \Application\Core\Utilities\Html                                       $html
 * @var \Application\Core\I18n\Translation\Translator                          $translator
 *
 * @var \Application\Showcase\Model\Order                                      $order
 * @var string                                                                 $title
 * @var string                                                                 $action_url
 * @var string                                                                 $check_status_url
 * @var string                                                                 $edit_customer_url
 * @var string                                                                 $edit_cc_action_url
 *
 * @var \Application\Showcase\Controller\Admin\Orders\OrderEditPanelCollection $orderEditPanelCollection
 */

switch ($_SERVER['HTTP_HOST']) {
    case 'hdc.dev':
    case 'www.hdc.dev':
    case 'areariservata.holidaydream.club':
        $_customer = 'hdc';
        break;

    default:
        $_customer = null;
        break;
}

?>
<div class="section">

	<h2><?= $title; ?></h2>

	<?php include 'messages.php'; ?>

	<div id="order-view">
		<div id="order-view-head">
			<div id="order-view-head-wrapper">
				<dl class="order-details order-view-head-box order-view-head-box-first">
					<dt><?= $translator->trans('Customer'); ?></dt>
                    <?php if ($edit_customer_url): ?>
                        <dd><a href="<?= $edit_customer_url; ?>"><?= $order->getCustomerName(); ?></a></dd>
                    <?php else: ?>
                        <dd><?= $order->getCustomerName(); ?></dd>
                    <?php endif; ?>
					<dt><?= $translator->trans('Status'); ?></dt>
					<dd>
                        <?php
                        echo $lang->get('order_status_' . $order->status);

                        if ($check_status_url) {
                            echo ' [ <a href="', $check_status_url, '" id="order-check-status" title="', $translator->trans('Order %id%: Reply from the payment gateway', array('%id%' => $order->id)), '">', $translator->trans('Verify'), '</a> ]';
                        }
                        ?>
                    </dd>
					<dt><?= $translator->trans('Ordered at'); ?></dt>
					<dd><?= $order->ordered_at ? $order->ordered_at->format('d/m/Y') : '-'; ?></dd>
					<dt><?= $translator->trans('Paid at'); ?></dt>
					<dd><?= $order->paid_at ? $order->paid_at->format('d/m/Y') : '-'; ?></dd>
					<dt><?= $translator->trans('Processed at'); ?></dt>
					<dd><?= $order->processed_at ? $order->processed_at->format('d/m/Y') : '-'; ?></dd>
					<?php if ($order->getTrackingCode()): ?>
						<dt><?= $translator->trans('Tr. code'); ?></dt>
						<dd><?= $order->getTrackingCode() ?: '-'; ?></dd>
					<?php endif; ?>
					<?php if ($order->hasProcessNote()): ?>
						<dt><?= $translator->trans('Process note'); ?></dt>
						<dd><?= $order->getProcessNote(); ?></dd>
                    <?php endif; ?>
				</dl>
				<div class="order-view-head-box">
					<h3><?= $translator->trans('Billing information'); ?></h3>
					<address><?= $order->invoice_address_text; ?></address>
					<?php if ($order->customer_code_name): ?>
						<dl>
							<dt><?= $lang->get($order->customer_code_name . '_short'); ?></dt>
							<dd><?= $order->customer_code_value ?: ''; ?></dd>
						</dl>
					<?php else: ?>
						<dl>
							<dt><?= $translator->trans('Customer code'); ?></dt>
							<dd><a href="#order-cc" id="order-cc-link" title="<?= $translator->trans('Edit the customer code'); ?>"><?= $translator->trans('Edit'); ?></a></dd>
						</dl>
					<?php endif; ?>

					<div style="display: none;">
						<form action="<?= $edit_cc_action_url; ?>" method="post" id="order-cc">
							<fieldset>
								<dl class="extend">
									<dt><label><?= $translator->trans('Name'); ?></label></dt>
									<dd class="small">
                                        <label>
                                            <select name="customer_code_name">
                                                <?= $html->select(array('codice_fiscale' => $translator->trans('Tax code'), 'partita_iva' => $translator->trans('VAT code')), $order->customer_code_name); ?>
                                            </select>
                                        </label>
									</dd>
								</dl>
								<dl class="extend">
									<dt><label><?= $translator->trans('Value'); ?></label></dt>
									<dd class="small">
                                        <label><input type="text" name="customer_code_value" value="<?= $order->customer_code_value; ?>" class="input_text" /></label>
									</dd>
								</dl>
							</fieldset>
							<fieldset>
								<input type="submit" value="<?= $translator->trans('Save'); ?>" class="btn" />
							</fieldset>
						</form>
					</div>
				</div>

				<?php if ($_customer === 'hdc'): ?>
					<div class="order-view-head-box">
						<h3>Luogo di ritiro</h3>
						<address><?= $order->custom_shipping_name; ?></address>
					</div>
				<?php else: ?>
					<div class="order-view-head-box">
						<h3><?= $translator->trans('Shipping address'); ?></h3>
						<address><?= $order->shipping_address_text; ?></address>
					</div>
				<?php endif; ?>
			</div>
		</div><!-- #order-view-head -->

		<div id="order-view-rows">
			<table class="pongho-table">
				<thead>
					<tr>
						<th class="main"><?= $translator->trans('Product'); ?></th>
						<th class="price"><?= $translator->trans('Price'); ?></th>
						<th class="quantity"><?= $translator->trans('Quantity'); ?></th>
						<th class="total"><?= $translator->trans('Total'); ?></th>
					</tr>
				</thead>
				<tfoot>
					<tr class="order-view-subtotal">
						<td colspan="3" style="text-align: right;"><?= $translator->trans('Products total'); ?>:</td>
						<td><?= $order->formatProductsTotal(); ?></td>
					</tr>
					<?php if ($order->hasDiscounts()): ?>
						<?php foreach ($order->getDiscounts() as $discount): ?>
							<tr>
								<td colspan="3" style="text-align: right;"><?= $discount->name(); ?>:</td>
								<td><?= $discount->formatValue(); ?></td>
							</tr>
						<?php endforeach; ?>
						<tr class="order-view-subtotal">
                            <td colspan="3" style="text-align: right;"><?= $translator->trans('Subtotal'); ?>:</td>
							<td><?= $order->formatSubtotal(); ?></td>
						</tr>
					<?php endif; ?>
					<tr>
                        <td colspan="3" style="text-align: right;"><?= $order->payment->name; ?>:</td>
						<td><?= $order->formatPaymentCost(); ?></td>
					</tr>
					<tr>
                        <td colspan="3" style="text-align: right;"><?= $order->shipping->name; ?>:</td>
						<td><?= $order->formatShippingCost(); ?></td>
					</tr>
					<?php if ($site->getOption('enable_tax')): ?>
						<tr class="order-view-subtotal">
                            <td colspan="3" style="text-align: right;"><?= $translator->trans('Taxable'); ?>:</td>
							<td><?= $order->formatTaxable(); ?></td>
						</tr>
						<tr>
                            <td colspan="3" style="text-align: right;"><?= $site->getOption('tax_name') ?>:</td>
							<td><?= $order->formatTaxCost(); ?></td>
						</tr>
					<?php endif; ?>
					<tr class="order-view-total">
                        <td colspan="4" style="text-align: right;"><?= $order->formatTotal(); ?></td>
					</tr>
				</tfoot>
				<tbody>
					<?php foreach ($order->getRows() as $row): ?>
					<tr>
						<td class="main">
							<h4><?= $row->title(); ?></h4>

                            <?php if ($row->code()): ?>
                                <span class="code">Cod. <?= $row->code(); ?></span>
                            <?php endif; ?>

                            <?php if ($row->size()): ?>
                                <span class="size"><?= $translator->trans('Size'), ': ', $row->sizename(); ?></span>
                            <?php endif; ?>

                            <?php if ($order->isOrder() && $row->availabilities() < $row->quantity()): ?>
                                <span style="color: red;"><?= $translator->trans('The availability of this product is less than the amount requested in the order.'); ?></span>
                            <?php endif; ?>
						</td>
						<td class="price">
							<?php if ($row->isDiscounted()): ?>
								<s class="real-price"><?= $row->formatRealPrice(); ?></s>
								<span class="sale-price discounted"><?= $row->formatPrice(); ?></span>
							<?php else: ?>
								<span class="sale-price"><?= $row->formatPrice(); ?></span>
							<?php endif; ?>
						<td class="quantity"><?= $row->quantity(); ?></td>
						<td class="total"><?= $row->formatTotal(); ?></td>
					</tr>
					<?php endforeach; ?>
				</tbody>
			</table>

			<?php if ($order->note()): ?>
				<h4><?= $lang->get('order_note'); ?></h4>
				<p><?= $order->note(); ?></p>
			<?php endif; ?>
		</div><!-- #order-view-rows -->

        <?php if (count($orderEditPanelCollection)): ?>
			<div class="order-panel">
				<div class="order-panel__buttons">
					<?php
					/** @var \Application\Showcase\Controller\Admin\Orders\OrderEditPanelInterface $panel */
					foreach ($orderEditPanelCollection as $panel):
						?>
						<a href="#order-panel--<?= $panel->getId(); ?>" class="pongho-button primary">
							<?= $panel->getLabel(); ?>
						</a>
					<?php endforeach; ?>
				</div>

                <?php
                /** @var \Application\Showcase\Controller\Admin\Orders\OrderEditPanelInterface $form */
                foreach ($orderEditPanelCollection as $panel):
                    ?>
					<div id="order-panel--<?= $panel->getId(); ?>" class="order-panel__content">
						<?= $panel->renderPanel($order); ?>
					</div>
                <?php endforeach; ?>
			</div>

			<script>
                (function (d) {
                    "use strict";

                    var buttonsContainer = d.querySelector('.order-panel__buttons'),
						buttons = buttonsContainer.getElementsByTagName('a'),
						panels = d.querySelectorAll('.order-panel__content'),
						cancels = d.querySelectorAll('.order-panel__content .cancel');

                    function forEach(nodes, callback) {
                        Array.prototype.slice.call(nodes).forEach(callback);
                    }

                    forEach(buttons, function (button) {
                        button.addEventListener('click', function (event) {
                            event.preventDefault();

                            buttonsContainer.style.display = 'none';

                            forEach(panels, function (panel) {
                                panel.style.display = 'none';
                            });

                            var panel = d.querySelector(event.target.getAttribute('href'));

                            if (panel) {
                                panel.style.display = 'block';
                            }
                        });
                    });

                    forEach(cancels, function (cancel) {
                        cancel.addEventListener('click', function (event) {
                            event.preventDefault();

                            buttonsContainer.style.display = 'block';

                            forEach(panels, function (panel) {
                                panel.style.display = 'none';
                            });
                        });
                    });

                }(document));
			</script>
        <?php endif; ?>
	</div><!-- #order-view -->

</div>
