<?php
/**
 * @var \Application\Core\I18n\Translation\Translator $translator
 * @var \Pongho\Template\Html                        $html
 * @var string                                       $action_form
 * @var string                                       $disable_showcase_url
 * @var array                                        $size_guide_node_types
 */
?><form action="<?php echo $action_form; ?>" method="post" class="section">

	<h2><?php echo $translator->trans('Options'); ?></h2>

	<?php
    include 'tabs.php';
    include 'messages.php';
    ?>

	<fieldset class="panel">
		<dl class="extend">
			<dt><label><?php echo $translator->trans('Options'); ?></label></dt>
			<dd><label><input type="checkbox" name="options[enable_code]"<?php echo $value_enable_code ? ' checked="checked"' : '' ?>> <span><?php echo $translator->trans('Enable the field for the product code'); ?></span></label></dd>
			<dd><label><input type="checkbox" name="options[enable_price]"<?php echo $value_enable_price ? ' checked="checked"' : '' ?>> <span><?php echo $translator->trans('Enable the field for the product price'); ?></span></label></dd>
			<dd><label><input type="checkbox" name="options[enable_availabilities]"<?php echo $value_enable_availabilities ? ' checked="checked"' : '' ?>> <span><?php echo $translator->trans('Enable the availabilities'); ?></span></label></dd>
			<dd><label><input type="checkbox" name="options[hide_unavailable_from_archives]"<?php echo $value_hide_unavailable_from_archives ? ' checked="checked"' : '' ?>> <span><?php echo $translator->trans('Hide unavailable products from the archives'); ?></span></label></dd>
			<dd><label><input type="checkbox" name="options[enable_sizes]"<?php echo $value_enable_sizes ? ' checked="checked"' : '' ?>> <span><?php echo $translator->trans('Enable the sizes'); ?></span></label></dd>
		</dl>
		<dl class="extend">
			<dt><?php echo $translator->trans('Sizes guide'); ?></dt>
			<dd class="small">
				<select name="options[size_guide_node_type]" id="field-size-guide-node-type">
					<option value=""><?php echo $translator->trans('Disabled'); ?></option>
					<?php echo $html->select($size_guide_node_types, $value_size_guide_node_type); ?>
				</select>
			</dd>
		</dl>
	</fieldset>

	<fieldset class="panel">
		<h3><?php echo $translator->trans('Disable showcase'); ?></h3>
		<p><?php echo $translator->trans('<a href="%url%">Click here</a> to convert this catalog in a normal node', array('%url%' => $disable_showcase_url)); ?></p>
	</fieldset>

	<fieldset class="btn">
		<input type="submit" value="<?php echo $translator->trans('Save'); ?>" class="primary" />
	</fieldset>

</form><!-- .section -->
