/**
 * JS per la gestione delle taglie.
 *
 * @package		Pongho2
 * @author		Daniele De Nobili
 * @version		1.0
 * @copyright	© 2012, Web Agency Meta Line S.r.l.
 *
 * @depends		jquery-1.7.1.min.js
 *				jquery-ui-1.8.17.custom.min.js
 */

$(document).ready(function () {

	var form = $('#sizes-form'),
		sizes = $('#sizes-sortable'),
		blankItem = sizes.find('.blank-item').clone(),
		counter = 1,
		wrapper = $('<div />').appendTo(form);

	sizes.sortable({
		delay: 200,
		forcePlaceholderSize: true,
		handle: 'div.size-item div.size-handle',
		helper:	'clone',
		items: 'li',
		opacity: .6,
		placeholder: 'size-item-placeholder',
		revert: 250,
		tolerance: 'pointer',
		toleranceElement: '> div'
	});

	// eliminazione di una taglia
	sizes.on('click', 'a.size-item-delete', function (event) {
		var li = $(this).closest('li');

		li.fadeOut(function () {
			li.remove();
		});

		event.preventDefault();
	});

	// pulsante per aggiungere le nuove taglie
	form.find('.add-item').on('click', function (event) {
		var row = blankItem.clone();

		row
			.find('input, select, textarea').each(function () {
				this.name = this.name.replace('[new]', '[new' + counter + ']');
			}).end()
			.attr('id', 'size-item-new' + counter)
			.appendTo(sizes)
			.show();

		counter++;
		event.preventDefault();
	});

	// invio della form
	form.submit(function (event) {
		var code = '', pos = 1;

		$.each(sizes.sortable('toArray'), function (index, id) {
			if (id === '') {
				return;
			}

			var size_id = id.match(/(.+)[-=_](.+)/);

			code += '<input type="hidden" name="sizes[' + ((2 in size_id) ? size_id[2] : id) + '][position]" value="' + (pos++) + '">';
		});

		wrapper.html(code);
	});
});
