/*jslint nomen: true, plusplus: true, passfail: true, browser: true, devel: true */
/*global $, jQuery, Pongho, wysiwygOptions */

/**
 * JS per la gestione delle taglie dei prodotti.
 *
 * @package        Pongho2
 * @author        Daniele De Nobili
 * @version        1.0
 * @copyright    © 2012, Web Agency Meta Line S.r.l.
 *
 * @depends        jquery-1.7.1.min.js
 */

$.fn.sizesEditor = function () {
    "use strict";

    var KEY_BACKSPACE = 8,
        KEY_SPACE = 32,
        KEY_COMMA = 44,
        KEY_DOT = 46;

    var select = $('#field-node-size_type_id'),
        fieldset = $('#fieldset-node-sizes-table');

    // Modifico la tabella delle taglie quando cambia il tipo.
    function changeSizesType() {
        select.attr('disabled', 'disabled');

        fieldset.addClass('loading').css('height', 200).empty().load(sizes.url + '&size_type=' + select.val(), function () {
            fieldset.removeClass('loading').css('height', 'auto').find('table').tableManager();
            select.removeAttr('disabled');

            fieldset.find('.repeater')
                .repeater()
                .repeater('add')
            ;
        });
    }

    select.on('change', changeSizesType);

    changeSizesType();

    // Assegno lo stesso prezzo a tutte le taglie
    function setColValue(colClass, value) {
        if (colClass) {
            fieldset.find('input.' + colClass).val(value);
        }
    }

    fieldset.on('click', 'input.col-value-setter', function () {
        var button = $(this),
            input = button.prev();

        setColValue(input.data('col'), input.val());
    });

    fieldset.on('keypress', 'input.col-value', function (event) {
        var input = $(this);

        if (event.which == 13) {
            event.preventDefault();
            setColValue(input.data('col'), input.val());
        }

        if (input.data('type') === 'number' && (event.which < 48 || event.which > 57) && event.which != KEY_BACKSPACE && event.which != KEY_SPACE && event.which != KEY_COMMA && event.which != KEY_DOT) {
            event.preventDefault();
        }
    });

    fieldset.on('click', '#select-custom-size-type', function () {
        select.val('custom').change();
    });
};

(function ($) {
    "use strict";

    var onCreatePanel = function (el) {
        $('#tabsizes').sizesEditor();
    }, tabsPanel = $('.form-wrapper');

    if (Pongho.action !== 'add') {
        tabsPanel.on('after-update', function () {
            onCreatePanel($(this));
        });
    }

    onCreatePanel(tabsPanel);

}(jQuery));
