/**
 * google-shopping.js
 *
 * @author Daniele De Nobili
 */

/*jslint nomen: true, plusplus: true, passfail: true, browser: true, devel: true */
/*global $ */

$(function () {
    "use strict";

    $('.google-shopping__warning').tooltip({
        items: '.google-shopping__check',
        content: function () {
            return $(this).find('div').html();
        },
        position: {
            my: 'left+5 center',
            at: 'right center',
            using: function (position, feedback) {
                $(this).css(position);

                $('<div>')
                    .addClass('google-shopping__tooltip__arrow')
                    .addClass(feedback.vertical)
                    .addClass(feedback.horizontal)
                    .appendTo(this);
            }
        },
        tooltipClass: 'google-shopping__tooltip'
    });
});
