/**
 * specUtilities.js
 *
 * @author Daniele De Nobili
 */

/*jslint nomen: true, plusplus: true, passfail: true, browser: true, devel: true */
/*global $, jasmine, describe, it, xdescribe, xit, beforeEach, afterEach, expect, loadFixtures, spyOnEvent */
/*global Pongho */

describe('Formato del prezzo', function () {
    'use strict';

    it('Dovrebbe formattare correttamente il prezzo', function () {
        var prices = [
            {'original': 0, 'expected': '€ 0,00'},
            {'original': 1, 'expected': '€ 1,00'},
            {'original': 1.23, 'expected': '€ 1,23'},
            {'original': 123, 'expected': '€ 123,00'},
            {'original': 123456, 'expected': '€ 123.456,00'},
            {'original': 123456789, 'expected': '€ 123.456.789,00'},
            {'original': 123456789.12, 'expected': '€ 123.456.789,12'}
        ];

        $.map(prices, function (price) {
            expect(Pongho.Shop.formatPrice(price.original)).toBe(price.expected);
        });
    });
});
