/**
 * specProduct.js
 *
 * @author Daniele De Nobili
 */

/*jslint nomen: true, plusplus: true, passfail: true, browser: true, devel: true */
/*global $, jasmine, describe, it, xdescribe, xit, beforeEach, afterEach, expect, loadFixtures, spyOnEvent */
/*global Pongho */

jasmine.getFixtures().fixturesPath = 'spec/fixtures';
jasmine.getStyleFixtures().fixturesPath = 'spec/fixtures';

describe('Carrello', function () {
    'use strict';

    beforeEach(function () {
        loadFixtures('cart.html');

        Pongho.Shop.cartManager();

        this.$rows = $('#cart-table').find('.row');
        this.$subtotal = $('#cart-subtotal');
    });

    it('I totali dovrebbero essere corretti anche al primo caricamento della pagina', function () {
        expect(this.$rows.eq(0).find('.sale-total').text()).toBe('€ 10,00');
        expect(this.$rows.eq(1).find('.sale-total').text()).toBe('€ 24,00');
        expect(this.$rows.eq(2).find('.sale-total').text()).toBe('€ 12,00');
        expect(this.$subtotal.text()).toBe('€ 46,00');
    });

    it('Al "change" di una quantità, dovrebbe aggiornare i totali', function () {
        this.$rows.eq(1).find('.quantity-field').val(2).trigger('change');

        expect(this.$rows.eq(1).find('.sale-total').text()).toBe('€ 16,00');
        expect(this.$subtotal.text()).toBe('€ 38,00');
    });

    it('Al "input" di una quantità, dovrebbe aggiornare i totali', function () {
        this.$rows.eq(1).find('.quantity-field').val(2).trigger('input');

        expect(this.$rows.eq(1).find('.sale-total').text()).toBe('€ 16,00');
        expect(this.$subtotal.text()).toBe('€ 38,00');
    });

    it('Al "keyup" di una quantità, dovrebbe aggiornare i totali', function () {
        this.$rows.eq(1).find('.quantity-field').val(2).trigger('keyup');

        expect(this.$rows.eq(1).find('.sale-total').text()).toBe('€ 16,00');
        expect(this.$subtotal.text()).toBe('€ 38,00');
    });

    it('Al "blur" di una quantità, dovrebbe aggiornare i totali', function () {
        this.$rows.eq(1).find('.quantity-field').val(2).trigger('blur');

        expect(this.$rows.eq(1).find('.sale-total').text()).toBe('€ 16,00');
        expect(this.$subtotal.text()).toBe('€ 38,00');
    });

    it('Dovrei poter inserire solo numeri', function () {
        var field = this.$rows.eq(2).find('.quantity-field');

        field.val('foo').trigger('change');
        expect(field.val()).toBe('1');

        field.val('1foo').trigger('change');
        expect(field.val()).toBe('1');

        field.val('4bar').trigger('change');
        expect(field.val()).toBe('4');
    });

    xit('Al cambio della quantità dovrebbe eseguire una chiamata ajax per salvare il dato');

    describe('Tasti di aiuto per il cambio delle quantità', function () {
        it('Premendo "+" dovrebbe incrementare la quantità', function () {
            this.$rows.eq(1).find('.quantity-field-increase').trigger('click');

            expect(this.$rows.eq(1).find('.sale-total').text()).toBe('€ 32,00');
            expect(this.$subtotal.text()).toBe('€ 54,00');
        });

        it('Premendo "-" dovrebbe decrementare la quantità', function () {
            this.$rows.eq(1).find('.quantity-field-decrease').trigger('click');

            expect(this.$rows.eq(1).find('.sale-total').text()).toBe('€ 16,00');
            expect(this.$subtotal.text()).toBe('€ 38,00');
        });
    });
});
