<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Showcase
 */

namespace Application\Showcase\Payment\ZeroOrder;

use Application\Showcase\Model\Order;
use Application\Showcase\Payment\BasePayment;
use Application\Showcase\Payment\PaymentFailResponse;
use Application\Showcase\Payment\PaymentOptions;
use Application\Showcase\Payment\PaymentResponse;
use Application\Showcase\Payment\TicketResponse;
use Pongho\Http\RedirectResponse;
use Pongho\Http\Request;
use Pongho\Utilities\DateTime;

/**
 * Rappresenta il metodo di pagamento base.
 */
class Payment extends BasePayment
{
    /**
     * {@inheritdoc}
     */
    public function preparePayment()
    {
        $this->order->convertCartToOrder(Order::STATUS_ORDER);
        $this->order->paid_at = new DateTime();

        return $this;
    }

    /**
     * {@inheritdoc}
     */
    public function handlePayment(PaymentOptions $options)
    {
        $options = $options->get($this->order);

        if (!array_key_exists('ticket_url', $options)) {
            throw new \InvalidArgumentException('The "ticket_url" option not exists!');
        }

        return new PaymentResponse(new RedirectResponse($options['ticket_url']));
    }

    /**
     * {@inheritdoc}
     */
    public function handleCancel($redirect_url)
    {
        return new PaymentFailResponse(new RedirectResponse($redirect_url));
    }

    /**
     * {@inheritdoc}
     */
    public function handleListener(Request $request, PaymentOptions $options): never
    {
        throw new \BadMethodCallException(sprintf('Listener is not implemented for %s handler!', static::class));
    }

    /**
     * {@inheritdoc}
     */
    public function handleTicket()
    {
        return new TicketResponse(true);
    }
}
