<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Showcase
 */

namespace Application\Showcase\Payment\Volksbank;

use Application\Showcase\Model\Order;
use Application\Showcase\Payment\BaseListener;
use Application\Showcase\Payment\ListenerResponse;
use Application\Showcase\Payment\PaymentOptions;
use Pongho\Http\Request;
use Pongho\Http\Response;
use Pongho\Utilities\DateTime;

/**
 * Gestisce le notifiche immediate di pagamento (IPN) provenienti da PayPal.
 */
class Listener extends BaseListener
{
    /**
     * {@inheritdoc}
     */
    public function handle(Request $request, PaymentOptions $options)
    {
        $options = $options->get($this->order);

        if ($this->isVerifiedPaymentId() && $this->isNotProcessed()) {
            if (isset($_POST['Error'])) {
                $this->order->status = Order::STATUS_PAYMENT_FAILED;
                $this->order->payment_details = serialize($_POST);

                $redirect_url = $options['cancel_url'];
                $redirect_url .= (str_contains((string) $redirect_url, '?') ? '&' : '?') . 'error=' . $_POST['Error'];

                return new ListenerResponse(false, new Response('REDIRECT=' . $redirect_url));
            }

            if ($this->isVerifiedHash() && isset($_POST['result'])) {
                switch ($_POST['result']) {
                    case 'APPROVED':
                        $this->order->status = Order::STATUS_PAYMENT_AUTHORIZED;
                        $redirect_url = $options['ticket_url'];
                        $order_confirmed = true;

                        break;

                    case 'CAPTURED':
                        $this->order->status = Order::STATUS_ORDER;
                        $this->order->paid_at = new DateTime();
                        $redirect_url = $options['ticket_url'];
                        $order_confirmed = true;

                        break;

                        // case 'NOT APPROVED':
                        // case 'NOT CAPTURED':
                        // case 'DENIED BY RISK':
                        // case 'HOST TIMEOUT':
                    default:
                        $this->order->status = Order::STATUS_PAYMENT_FAILED;
                        $redirect_url = $options['cancel_url'];
                        $order_confirmed = false;

                        break;
                }

                $details = $_POST;
                $details['processed'] = true;
                $this->order->payment_details = serialize($details);

                return new ListenerResponse($order_confirmed, new Response('REDIRECT=' . $redirect_url));
            }
        }

        throw new \RuntimeException('This request is not a valid transaction!');
    }

    /**
     * Verifica la corrispondenza del codice hash dell’ordine.
     *
     * @return bool
     * @throws \RuntimeException
     */
    protected function isVerifiedPaymentId()
    {
        $details = unserialize($this->order->payment_details);
        $payment_id = is_array($details) && isset($details['paymentid']) ? $details['paymentid'] : '';

        if (isset($_POST['paymentid']) && $_POST['paymentid'] === $payment_id) {
            return true;
        }

        throw new \RuntimeException(sprintf('Fail %s.', __METHOD__));
    }

    /**
     * Controlla se l’ordine è già stato processato.
     *
     * @return bool
     * @throws \RuntimeException
     */
    protected function isNotProcessed()
    {
        $details = unserialize($this->order->payment_details);
        $processed = is_array($details) && isset($details['processed']) ? $details['processed'] : false;

        if ($processed === false) {
            return true;
        }

        throw new \RuntimeException(sprintf('Fail %s.', __METHOD__));
    }

    /**
     * Verifica la corrispondenza del codice hash dell’ordine.
     *
     * @return bool
     * @throws \RuntimeException
     */
    protected function isVerifiedHash()
    {
        if (isset($_POST['udf1']) && $_POST['udf1'] === $this->order->payment_hash) {
            return true;
        }

        throw new \RuntimeException(sprintf('Fail %s.', __METHOD__));
    }
}
