<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Showcase
 */

namespace Application\Showcase\Payment;

use Application\Showcase\Model\Order;

/**
 * Gestisce le opzioni per il pagamento.
 */
class PaymentOptions
{
    /**
     * Percorso base dello shop.
     *
     * @var string
     */
    protected $path;

    /**
     * Restituisce una istanza della classe.
     *
     * @param string $path Percorso base dello shop.
     * @return PaymentOptions
     *
     * @deprecated
     */
    public static function newInstance($path)
    {
        trigger_error(
            'The method ' . __METHOD__ . ' is deprecated. Use the constructor instead.',
            E_USER_DEPRECATED
        );

        return new PaymentOptions($path);
    }

    /**
     * @param string $path Percorso base dello shop.
     */
    public function __construct($path)
    {
        $this->path = '/' . trim($path, '/');
    }

    /**
     * Restituisce le opzioni per il pagamento in base all’ordine passato.
     *
     * @return array
     */
    public function get(Order $order)
    {
        $options = $order->payment ? $order->payment->getHandlerOptions() : [];

        return array_merge($options, [
            'ticket_url'   => absolute_url($this->path . '/ticket/' . $order->id . '/?hash=' . $order->payment_hash),
            'cancel_url'   => absolute_url($this->path . '/paymentcancel/' . $order->id . '/'),
            'listener_url' => absolute_url($this->path . '/listener/' . $order->payment_id . '/?o=' . $order->id),
        ]);
    }
}
