<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Showcase
 */

namespace Application\Showcase\Payment;

use Pongho\Http\Response;

class PaymentFailResponse
{
    /**
     * @var Response
     */
    protected $httpResponse;

    /**
     * @var bool
     */
    protected $sendNotifyToAdmin = false;

    /**
     * @param Response $httpResponse
     */
    public function __construct(?Response $httpResponse = null)
    {
        $this->httpResponse = $httpResponse;
    }

    /**
     * @return Response
     */
    public function getHttpResponse()
    {
        return $this->httpResponse;
    }

    /**
     * @return $this
     */
    public function setHttpResponse(Response $response)
    {
        $this->httpResponse = $response;

        return $this;
    }

    /**
     * @param bool $sendNotifyToAdmin
     * @return $this
     */
    public function setSendNotifyToAdmin($sendNotifyToAdmin)
    {
        $this->sendNotifyToAdmin = $sendNotifyToAdmin;

        return $this;
    }

    /**
     * @return bool
     */
    public function getSendNotifyToAdmin()
    {
        return $this->sendNotifyToAdmin;
    }
}
