<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Showcase
 */

namespace Application\Showcase\Payment\PagOnline\Exception;

class VerifyException extends \Exception
{
    /**
     * @var \IgfsCgVerify
     */
    protected $verify;

    /**
     * VerifyException constructor.
     */
    public function __construct(\IgfsCgVerify $verify)
    {
        $this->verify = $verify;

        parent::__construct(sprintf('[%s] %s', $verify->rc, $verify->errorDesc));
    }

    /**
     * @return \IgfsCgVerify
     */
    public function getVerify()
    {
        return $this->verify;
    }
}
