<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Showcase
 */

namespace Application\Showcase\Payment;

use Pongho\Http\Response;

/**
 * Risposta del listener.
 */
class ListenerResponse
{
    /**
     * Indica se l’ordine può essere confermato.
     *
     * @var bool
     */
    protected $order_confirmed = false;

    /**
     * Indica se inviare una notifica in caso di pagamento fallito.
     *
     * @var bool
     */
    private $sendFailedNotification = false;

    /**
     * Risposta.
     *
     * @var Response
     */
    protected $response;

    /**
     * @param bool     $order_confirmed
     * @param Response $response
     */
    public function __construct($order_confirmed = false, ?Response $response = null)
    {
        $this->order_confirmed = (bool) $order_confirmed;
        $this->response = $response;
    }

    /**
     * Imposta il flag per la conferma dell’ordine.
     *
     * @param bool $order_confirmed
     * @return $this
     */
    public function confirmOrder($order_confirmed = true)
    {
        $this->order_confirmed = (bool) $order_confirmed;

        return $this;
    }

    /**
     * Indica se l’ordine è confermato.
     *
     * @return bool
     */
    public function isOrderConfirmed()
    {
        return $this->order_confirmed;
    }

    /**
     * @return bool
     */
    public function haveToSendFailedNotification()
    {
        return $this->sendFailedNotification;
    }

    /**
     * @param bool $sendFailedNotification
     * @return $this
     */
    public function setSendFailedNotification($sendFailedNotification = true)
    {
        $this->sendFailedNotification = (bool) $sendFailedNotification;

        return $this;
    }

    /**
     * Imposta la risposta.
     *
     * @return $this
     */
    public function setResponse(Response $response)
    {
        $this->response = $response;

        return $this;
    }

    /**
     * Restituisce la risposta.
     *
     * @return Response
     */
    public function getResponse()
    {
        if ($this->response === null) {
            return new Response('OK');
        }

        return $this->response;
    }
}
