<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Showcase
 */

namespace Application\Showcase\Model;

use ActiveRecord\Base as Model;

/**
 * Modello per i nomi delle taglie.
 *
 * @property int    $id
 * @property int    $size_type_id
 * @property string $name
 * @property int    $position
 */
class SizeName extends Model
{
    /**
     * Nome della tabella.
     *
     * @var string
     */
    public static $table_name = 'nodes_sizes_names';

    /**
     * Cerca un record SizeName in base al nome.
     *
     * @param string $name
     * @return \Application\Showcase\Model\SizeName
     */
    public static function findByName($name)
    {
        return self::first([
            'conditions' => ['name = ?', (string) $name],
        ]);
    }

    /**
     * Restituisce il nome della taglia.
     *
     * @return string
     */
    public function name()
    {
        return $this->name;
    }

    /**
     * {@inheritdoc}
     */
    public function delete()
    {
        return $this->deleteNodesSizes() && parent::delete();
    }

    /**
     * Elimina le relazioni con il nodo.
     *
     * @return bool
     */
    public function deleteNodesSizes()
    {
        $options = [
            'conditions' => ['size_name_id = ?', $this->id],
        ];

        foreach (Size::all($options) as $size) {
            if (!$size->delete()) {
                return false;
            }
        }

        return true;
    }
}
