<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Showcase
 */

namespace Application\Showcase\Model;

use ActiveRecord\Base;

/**
 * @property int    $id
 * @property int    $discount_id
 * @property float  $value
 * @property string $value_type
 * @property float  $condition
 */
class OrderDiscountCondition extends Base
{
    /**
     * Nome della tabella.
     *
     * @var string
     */
    public static $table_name = 'shop_order_discounts_conditions';

    /**
     * @return float|string
     */
    public function getValue()
    {
        if ($this->value_type === '%') {
            return $this->value . '%';
        }

        return $this->value;
    }

    /**
     * @return string
     */
    public function formatValue()
    {
        if ($this->value_type === '%') {
            return $this->value . '%';
        }

        return format_price($this->value);
    }

    /**
     * @return float
     */
    public function getCondition()
    {
        return $this->condition;
    }

    /**
     * @return string
     */
    public function formatCondition()
    {
        return format_price($this->condition);
    }
}
