<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Showcase
 */

namespace Application\Showcase\Model;

use Application\Cms\Model\NodeType as Base;
use Application\Core\Model\ModuleSite;

/**
 * Modello per i tipi di nodo dello showcase.
 */
class NodeType extends Base
{
    /**
     * Lista dei tipi di taglia legati a questo modulo.
     *
     * @var array
     */
    protected $types_size;

    /**
     * Converte un modello `ModuleSite` in `NodeType`.
     *
     * @return \Application\Showcase\Model\NodeType
     */
    public static function cast(ModuleSite $module)
    {
        return new NodeType($module->attributes(), $module->isNewRecord());
    }

    /**
     * {@inheritdoc}
     */
    protected function getDefaultOptions()
    {
        $options = parent::getDefaultOptions();

        $options['enable_featured_image'] = true;
        $options['enable_code'] = true;
        $options['enable_price'] = true;
        $options['enable_availabilities'] = true;
        $options['hide_unavailable_from_archives'] = true;
        $options['enable_sizes'] = false;

        return $options;
    }

    /**
     * Restituisce la lista dei tipi di taglia relativi a questo modulo.
     *
     * La lista restituita contiene modelli di `Application\Showcase\Model\SizeType`.
     *
     * @return \Application\Showcase\Model\SizeType[]
     */
    public function getSizeTypes()
    {
        if ($this->types_size === null) {
            $this->types_size = SizeType::all([
                'conditions' => ['module_site_id = ?', $this->id],
                'order'      => 'title ASC',
            ]);
        }

        return $this->types_size;
    }

    /**
     * {@inheritdoc}
     */
    public function getDisallowedTaxonomyNames()
    {
        $names = parent::getDisallowedTaxonomyNames();

        $names[] = 'sizes';

        return $names;
    }
}
