<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Showcase
 */

namespace Application\Showcase\Model\Manager;

use Application\Cms\Model\Manager\NodeManagerInterface;

/**
 * ProductManagerInterface
 */
interface ProductManagerInterface extends NodeManagerInterface
{
    /**
     * @param string $code
     * @param int    $languageId
     * @return \Application\Showcase\Model\Node
     */
    public function findByCode($code, $languageId);

    /**
     * {@inheritdoc}
     *
     * @return \Application\Showcase\Model\Node[]
     */
    public function search($keyword, $languageId, array $options = [], $orderBy = null, $limit = 50, $offset = 0);
}
