<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Showcase
 */

namespace Application\Showcase\Model\Helper;

use Application\Showcase\Model\Node;
use Application\Showcase\Model\OrderDiscount;

class ProductUrlGenerator implements ProductUrlGeneratorInterface
{
    /**
     * @var OrderDiscount
     */
    private $coupon;

    /**
     * @var string
     */
    private $queryString;

    /**
     * @return $this
     */
    public function setCoupon(OrderDiscount $coupon)
    {
        $this->coupon = $coupon;

        return $this;
    }

    /**
     * {@inheritdoc}
     */
    public function generateAddToCartUrl(Node $product)
    {
        return absolute_url(
            '/shop/addtocart/' . $product->getId() . '/' . $this->buildQueryString()
        );
    }

    /**
     * {@inheritdoc}
     */
    public function generatePermalink(Node $product)
    {
        return absolute_url(
            $product->permalink . $this->buildQueryString()
        );
    }

    /**
     * @return string
     */
    protected function buildQueryString()
    {
        if ($this->queryString === null) {
            $this->queryString = '';

            $qs = [];

            if ($this->coupon) {
                $qs['coupon'] = $this->coupon->getCode();
            }

            if ($qs) {
                $this->queryString = '?' . http_build_query($qs);
            }
        }

        return $this->queryString;
    }
}
