<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Showcase
 */

namespace Application\Showcase\Installer;

use Application\Core\Installer\Installer;
use Application\Core\Model\Module;

class ShowcaseInstaller extends Installer
{
    /**
     * Crea la struttura
     */
    public function install()
    {
        /** @var \Psr\Log\LoggerInterface $logger */
        $logger = $this->container->get('logger');

        $logger->info('[Showcase][Installer] Creazione delle tabelle dello Showcase');

        $schema = $this->getSchema();

        // Tipi di taglia
        $sizes_types_table = $schema->createTable('pongho_nodes_sizes_types');
        $sizes_types_table->addColumn('id', 'integer', ['unsigned' => true, 'autoincrement' => true]);
        $sizes_types_table->addColumn('module_site_id', 'integer', ['unsigned' => true]);
        $sizes_types_table->addColumn('node_id', 'integer', ['unsigned' => true, 'notnull' => false]);
        $sizes_types_table->addColumn('title', 'string', ['length' => 50, 'default' => '']);

        $sizes_types_table->setPrimaryKey(['id']);
        $sizes_types_table->addForeignKeyConstraint($schema->getTable('pongho_modules_sites'), ['module_site_id'], ['id']);
        $sizes_types_table->addForeignKeyConstraint($schema->getTable('pongho_nodes'), ['node_id'], ['id'], ['onDelete' => 'SET NULL']);

        // Nomi delle taglie
        $sizes_names_table = $schema->createTable('pongho_nodes_sizes_names');
        $sizes_names_table->addColumn('id', 'integer', ['unsigned' => true, 'autoincrement' => true]);
        $sizes_names_table->addColumn('size_type_id', 'integer', ['unsigned' => true, 'notnull' => false]);
        $sizes_names_table->addColumn('name', 'string', ['length' => 50, 'default' => '']);
        $sizes_names_table->addColumn('position', 'integer', ['unsigned' => true, 'default' => 0]);

        $sizes_names_table->setPrimaryKey(['id']);
        $sizes_names_table->addForeignKeyConstraint($sizes_types_table, ['size_type_id'], ['id']);

        // Taglie
        $sizes_table = $schema->createTable('pongho_nodes_sizes');
        $sizes_table->addColumn('id', 'integer', ['unsigned' => true, 'autoincrement' => true]);
        $sizes_table->addColumn('node_id', 'integer', ['unsigned' => true]);
        $sizes_table->addColumn('size_name_id', 'integer', ['unsigned' => true]);
        $sizes_table->addColumn('price', 'decimal', ['unsigned' => true, 'precision' => 12, 'scale' => 4, 'default' => 0]);
        $sizes_table->addColumn('offer', 'decimal', ['unsigned' => true, 'precision' => 12, 'scale' => 4, 'default' => 0]);
        $sizes_table->addColumn('weight', 'decimal', ['unsigned' => true, 'precision' => 12, 'scale' => 4, 'default' => 0]);
        $sizes_table->addColumn('availabilities', 'integer', ['unsigned' => true, 'default' => 0]);
        $sizes_table->addColumn('bound_in_cart', 'integer', ['unsigned' => true, 'default' => 0]);
        $sizes_table->addColumn('bound_in_cart_updated_at', 'datetime', ['notnull' => false]);
        $sizes_table->addColumn('bound_in_payment', 'integer', ['unsigned' => true, 'default' => 0]);
        $sizes_table->addColumn('bound_in_payment_updated_at', 'datetime', ['notnull' => false]);
        $sizes_table->addColumn('bound_in_order', 'integer', ['unsigned' => true, 'default' => 0]);
        $sizes_table->addColumn('gtin', 'string', ['default' => '', 'length' => 20]);
        $sizes_table->addColumn('mpn', 'string', ['default' => '', 'length' => 50]);
        $sizes_table->addColumn('gs_enabled', 'boolean', ['default' => false]);
        $sizes_table->addColumn('gs_type', 'string', ['default' => '', 'length' => 20]);
        $sizes_table->addColumn('shopping_points', 'integer', ['unsigned' => true, 'default' => 0]);

        $sizes_table->setPrimaryKey(['id']);
        $sizes_table->addForeignKeyConstraint($schema->getTable('pongho_nodes'), ['node_id'], ['id']);
        $sizes_table->addForeignKeyConstraint($sizes_names_table, ['size_name_id'], ['id']);

        $nodes_table = $schema->getTable('pongho_nodes');
        $nodes_table->addColumn('size_type_id', 'integer', ['unsigned' => true, 'notnull' => false]);
        $nodes_table->addColumn('code', 'string', ['length' => 200, 'default' => '']);
        $nodes_table->addColumn('price', 'decimal', ['unsigned' => true, 'precision' => 12, 'scale' => 4, 'default' => 0]);
        $nodes_table->addColumn('offer', 'decimal', ['unsigned' => true, 'precision' => 12, 'scale' => 4, 'default' => 0]);
        $nodes_table->addColumn('discount', 'decimal', ['unsigned' => true, 'precision' => 12, 'scale' => 4, 'default' => 0]);
        $nodes_table->addColumn('discount_type', 'string', ['length' => 1, 'default' => '']);
        $nodes_table->addColumn('availabilities', 'integer', ['unsigned' => true, 'default' => 0]);
        $nodes_table->addColumn('bound_in_cart', 'integer', ['unsigned' => true, 'default' => 0]);
        $nodes_table->addColumn('bound_in_cart_updated_at', 'datetime', ['notnull' => false]);
        $nodes_table->addColumn('bound_in_payment', 'integer', ['unsigned' => true, 'default' => 0]);
        $nodes_table->addColumn('bound_in_payment_updated_at', 'datetime', ['notnull' => false]);
        $nodes_table->addColumn('bound_in_order', 'integer', ['unsigned' => true, 'default' => 0]);
        $nodes_table->addColumn('gs_color', 'string', ['default' => '', 'length' => 255]);
        $nodes_table->addColumn('gs_gender', 'string', ['default' => '', 'length' => 20]);
        $nodes_table->addColumn('gs_age_group', 'string', ['default' => '', 'length' => 20]);
        $nodes_table->addColumn('gs_material', 'string', ['default' => '', 'length' => 255]);
        $nodes_table->addColumn('gs_pattern', 'string', ['default' => '', 'length' => 255]);
        $nodes_table->addColumn('shopping_points', 'integer', ['unsigned' => true, 'default' => 0]);
        $nodes_table->addColumn('exclude_from_order_amount_discount', 'boolean', ['default' => false]);

        $nodes_table->addForeignKeyConstraint($sizes_types_table, ['size_type_id'], ['id']);

        $terms_table = $schema->getTable('pongho_terms');
        $terms_table->addColumn('gs_category', 'string', ['default' => '', 'length' => 400]);

        $this->updateSchema();

        $this->fixRegisteredUpdates();
    }

    /**
     * Ripulisce il database e ripristina quanto è possibile allo stato precedente all'installazione
     */
    public function uninstall()
    {
        /** @var \Psr\Log\LoggerInterface $logger */
        $logger = $this->container->get('logger');

        $logger->info('[Showcase][Installer] Pulizia del database');

        // Reimposto i nodi dello showcase come nodi normali
        $this->restoreNodesControllers();

        // Rimuovo le tabelle dello Showcase
        $schema = $this->getSchema();

        $nodes_table = $schema->getTable('pongho_nodes');
        if ($nodes_table->hasColumn('size_type_id')) {
            foreach ($nodes_table->getForeignKeys() as $fk) {
                if ($fk->getColumns() === ['size_type_id']) {
                    $nodes_table->removeForeignKey($fk->getName());
                }
            }

            $nodes_table->dropColumn('size_type_id');
        }

        if ($nodes_table->hasColumn('code')) {
            $nodes_table->dropColumn('code');
        }

        if ($nodes_table->hasColumn('price')) {
            $nodes_table->dropColumn('price');
        }

        if ($nodes_table->hasColumn('offer')) {
            $nodes_table->dropColumn('offer');
        }

        if ($nodes_table->hasColumn('discount')) {
            $nodes_table->dropColumn('discount');
        }

        if ($nodes_table->hasColumn('discount_type')) {
            $nodes_table->dropColumn('discount_type');
        }

        if ($nodes_table->hasColumn('availabilities')) {
            $nodes_table->dropColumn('availabilities');
        }

        if ($nodes_table->hasColumn('bound_in_cart')) {
            $nodes_table->dropColumn('bound_in_cart');
        }

        if ($nodes_table->hasColumn('bound_in_cart_updated_at')) {
            $nodes_table->dropColumn('bound_in_cart_updated_at');
        }

        if ($nodes_table->hasColumn('bound_in_payment')) {
            $nodes_table->dropColumn('bound_in_payment');
        }

        if ($nodes_table->hasColumn('bound_in_payment_updated_at')) {
            $nodes_table->dropColumn('bound_in_payment_updated_at');
        }

        if ($nodes_table->hasColumn('bound_in_order')) {
            $nodes_table->dropColumn('bound_in_order');
        }

        if ($nodes_table->hasColumn('gs_color')) {
            $nodes_table->dropColumn('gs_color');
        }

        if ($nodes_table->hasColumn('gs_gender')) {
            $nodes_table->dropColumn('gs_gender');
        }

        if ($nodes_table->hasColumn('gs_age_group')) {
            $nodes_table->dropColumn('gs_age_group');
        }

        if ($nodes_table->hasColumn('gs_material')) {
            $nodes_table->dropColumn('gs_material');
        }

        if ($nodes_table->hasColumn('gs_pattern')) {
            $nodes_table->dropColumn('gs_pattern');
        }

        if ($nodes_table->hasColumn('shopping_points')) {
            $nodes_table->dropColumn('shopping_points');
        }

        if ($nodes_table->hasColumn('exclude_from_order_amount_discount')) {
            $nodes_table->dropColumn('exclude_from_order_amount_discount');
        }

        $terms_table = $schema->getTable('pongho_terms');
        if ($terms_table->hasColumn('gs_category')) {
            $terms_table->dropColumn('gs_category');
        }

        if ($schema->hasTable('pongho_nodes_sizes')) {
            $schema->dropTable('pongho_nodes_sizes');
        }

        if ($schema->hasTable('pongho_nodes_sizes_names')) {
            $schema->dropTable('pongho_nodes_sizes_names');
        }

        if ($schema->hasTable('pongho_nodes_sizes_types')) {
            $schema->dropTable('pongho_nodes_sizes_types');
        }

        $this->updateSchema();
    }

    /**
     * Reimposto i nodi dello showcase come nodi normali
     */
    protected function restoreNodesControllers()
    {
        $options = [
            'conditions' => [
                'controller = :controller',
                'controller' => \Application\Showcase\Controller\NodeController::class,
            ],
        ];

        /** @var Module $module */
        foreach (Module::all($options) as $module) {
            $module->controller = \Application\Cms\Controller\NodeController::class;
            $module->save();
        }
    }
}
