<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Showcase
 */

namespace Application\Showcase\GoogleShopping;

use Application\Core\I18n\Translation\Translator as CoreTranslator;
use Pongho\Sdk\GoogleShopping\PropertyInterface;
use Pongho\Sdk\GoogleShopping\TranslatorInterface;

class Translator implements TranslatorInterface
{
    /**
     * @var CoreTranslator
     */
    protected $translator;

    public function __construct(CoreTranslator $translator)
    {
        $this->translator = $translator;
    }

    /**
     * {@inheritdoc}
     */
    public function transRequiredProperty(PropertyInterface $property)
    {
        return $this->translator->trans(
            'Property "%property%" is required.',
            ['%property%' => $property->getTag()]
        );
    }

    /**
     * {@inheritdoc}
     */
    public function transTooLongPropertyValue(PropertyInterface $property, $max_length)
    {
        return $this->translator->trans(
            'Character limit for "%tag%" is %max_length%.',
            [
                '%tag%'        => $property->getTag(),
                '%max_length%' => $max_length,
            ]
        );
    }

    /**
     * {@inheritdoc}
     */
    public function transOutOfEnum(PropertyInterface $property, array $available_values)
    {
        return $this->translator->trans(
            'Property "%tag%" must be one of %availables%.',
            [
                '%tag%'        => $property->getTag(),
                '%availables%' => '"' . implode('", "', $available_values) . '"',
            ]
        );
    }

    /**
     * {@inheritdoc}
     */
    public function transUndefinedEndDate(PropertyInterface $property)
    {
        return $this->translator->trans(
            'You must define an end date in property "%tag%".',
            ['%tag%' => $property->getTag()]
        );
    }

    /**
     * {@inheritdoc}
     */
    public function transCategoryDoesNotExist(PropertyInterface $property, $category)
    {
        return $this->translator->trans(
            'Category "%category%" does not exist.',
            ['%category%' => $category]
        );
    }

    /**
     * {@inheritdoc}
     */
    public function transLinkNotValid(PropertyInterface $property, $link)
    {
        return $this->translator->trans(
            'The link "%link%" must start with "http://" or "https://".',
            ['%link%' => $link]
        );
    }

    /**
     * {@inheritdoc}
     */
    public function transCountryCodeError(PropertyInterface $property)
    {
        return $this->translator->trans(
            'The shipping country code must comply with the ISO 3166 and must be 2 letters.'
        );
    }
}
