<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Showcase
 */

namespace Application\Showcase\Entity;

use Application\Showcase\Model\Node;
use Application\Showcase\Utilities\Taxation;

/**
 * OrderRowInterface
 *
 * TODO: Da completare
 */
interface OrderRowInterface
{
    /**
     * Restituisce l’identificativo dell’ordine.
     *
     * @return int
     */
    public function getOrderId();

    /**
     * @return Node
     *
     * TODO: Il risultato dovrebbe essere un’interfaccia che permetta di gestire prodotti, taglie e qualsiasi altro oggetto inseribile in carrello.
     */
    public function getProduct();

    /**
     * Restituisce il codice del prodotto.
     *
     * @return string
     */
    public function code();

    /**
     * Restituisce lo "Stock Keeping Unit" del prodotto.
     *
     * @return string
     */
    public function sku();

    /**
     * Restituisce il titolo del prodotto.
     *
     * @see \Application\Cms\Model\Stuff::title()
     *
     * @param int    $length
     * @param string $continue
     * @param bool   $use_html_escape
     * @return string
     */
    public function title($length = null, $continue = '…', $use_html_escape = true);

    /**
     * Restituisce il contenuto del prodotto.
     *
     * @see \Application\Cms\Model\Stuff::content()
     *
     * @return string
     */
    public function content();

    /**
     * Restituisce il riassunto del contenuto del prodotto.
     *
     * @see \Application\Cms\Model\Stuff::excerpt()
     *
     * @param integer $length
     * @param string  $continue
     * @return string
     */
    public function excerpt($length = 20, $continue = '…');

    /**
     * Restituisce il permalink del prodotto.
     *
     * @see \Application\Cms\Model\Stuff::permalink()
     *
     * @return string
     */
    public function permalink();

    /**
     * Restituisce l’immagine del prodotto.
     *
     * @see \Application\Cms\Model\Node::image()
     *
     * @return \Application\Core\Model\File
     *
     * TODO: ImageInterface
     */
    public function image();

    /**
     * Restituisce la disponibilità massima del prodotto.
     *
     * @return int
     */
    public function availabilities();

    /**
     * Restituisce la taglia del prodotto.
     *
     * @return \Application\Showcase\Model\Size
     *
     * TODO: SizeInterface
     */
    public function size();

    /**
     * Restituisce il nome della taglia.
     *
     * @return string
     */
    public function sizename();

    /**
     * Restituisce la quantità.
     *
     * @return integer
     */
    public function quantity();

    /**
     * Restituisce il prezzo del prodotto.
     *
     * @param \Application\Showcase\Utilities\Taxation $taxation Oggetto per il calcolo delle tasse.
     * @return float
     */
    public function price(?Taxation $taxation = null);

    /**
     * Restituisce il prezzo formattato del prodotto.
     *
     * @param \Application\Showcase\Utilities\Taxation $taxation Oggetto per il calcolo delle tasse.
     * @return string
     */
    public function formatPrice(?Taxation $taxation = null);

    /**
     * Resituisce il totale della riga.
     *
     * Il totale della riga è calcolato sul prezzo scontato.
     *
     * @param \Application\Showcase\Utilities\Taxation $taxation Oggetto per il calcolo delle tasse.
     * @return float
     */
    public function total(?Taxation $taxation = null);

    /**
     * Resituisce il totale formattato della riga.
     *
     * Il totale della riga è calcolato sul prezzo scontato.
     *
     * @param \Application\Showcase\Utilities\Taxation $taxation Oggetto per il calcolo delle tasse.
     * @return string
     */
    public function formatTotal(?Taxation $taxation = null);

    /**
     * @return int
     */
    public function getShoppingPoints();
}
