<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Showcase
 */

namespace Application\Showcase\Domain\Order\Command;

use Application\Core\I18n\Translation\Translator;
use Application\Showcase\Discount\OrderDiscounts;
use Application\Showcase\Model\Order;
use Pongho\Http\Request;
use Pongho\Utilities\DateTime;

class ProcessOrderCommandFactory
{
    /**
     * @var OrderDiscounts
     */
    protected $orderDiscounts;

    /**
     * @var ProcessOrderNotifier
     */
    protected $notificationSender;

    /**
     * @var Translator
     */
    protected $translator;

    public function __construct(OrderDiscounts $orderDiscounts, ProcessOrderNotifier $sender, Translator $translator)
    {
        $this->orderDiscounts = $orderDiscounts;
        $this->notificationSender = $sender;
        $this->translator = $translator;
    }

    /**
     * @return ProcessOrderCommand
     */
    public function createFromRequest(Order $order, Request $request)
    {
        $attributes = $request->post->get('order', []);

        if (!is_array($attributes)) {
            $attributes = [];
        }

        $command = $this->createCommand();

        $command
            ->reset()
            ->setOrder($order)
            ->setDate($this->extractProcessDate($attributes))
            ->setTrackingCode($this->extractTrackingCode($attributes))
            ->setNote($this->extractProcessNote($attributes));

        return $command;
    }

    /**
     * @return ProcessOrderCommand
     */
    public function createCommand()
    {
        return new ProcessOrderCommand(
            $this->orderDiscounts,
            $this->notificationSender,
            $this->translator
        );
    }

    /**
     * @return DateTime
     */
    protected function extractProcessDate(array $attributes)
    {
        $processDate = $attributes['shipping_date'] ?? 'now';

        try {
            return new DateTime($processDate);
        } catch (\Exception) {
            return new DateTime('now');
        }
    }

    /**
     * @return null|string
     */
    protected function extractTrackingCode(array $attributes)
    {
        return isset($attributes['tracking_code']) ? trim($attributes['tracking_code']) : null;
    }

    /**
     * @return null|string
     */
    protected function extractProcessNote(array $attributes)
    {
        return isset($attributes['process_note']) ? trim($attributes['process_note']) : null;
    }
}
