<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Showcase
 */

namespace Application\Showcase\Domain\Order\Command;

use Application\Core\I18n\Translation\Translator;
use Application\Showcase\Model\Order;
use Pongho\Http\Request;

class CancelOrderCommandFactory
{
    /**
     * @var Translator
     */
    protected $translator;

    public function __construct(Translator $translator)
    {
        $this->translator = $translator;
    }

    /**
     * @return CancelOrderCommand
     */
    public function createFromRequest(Order $order, Request $request)
    {
        $command = $this->createCommand();

        $command
            ->reset()
            ->setOrder($order);

        return $command;
    }

    /**
     * @return CancelOrderCommand
     */
    public function createCommand()
    {
        return new CancelOrderCommand($this->translator);
    }
}
