<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Showcase
 */

namespace Application\Showcase\Domain;

class CommandResult
{
    /**
     * @var bool
     */
    private $successful = true;

    /**
     * @var string
     */
    private $message = '';

    /**
     * @var array
     */
    private $alerts = [];

    /**
     * @var array
     */
    private $errors = [];

    /**
     * @param bool   $successful
     * @param string $message
     */
    public function __construct($successful, $message = '', array $alerts = [], array $errors = [])
    {
        $this->successful = $successful;
        $this->message = $message;
        $this->alerts = $alerts;
        $this->errors = $errors;
    }

    /**
     * @return bool
     */
    public function isSuccessful()
    {
        return $this->successful;
    }

    /**
     * @return string
     */
    public function getMessage()
    {
        return $this->message;
    }

    /**
     * @return array
     */
    public function getAlerts()
    {
        return $this->alerts;
    }

    /**
     * @return array
     */
    public function getErrors()
    {
        return $this->errors;
    }
}
