<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Showcase
 */

namespace Application\Showcase\DependencyInjection;

use Application\Admin\Panels\PanelsManager;
use Application\Admin\Widgets\PanelWidgetsCollection;
use Application\Admin\Widgets\WidgetsCollection;
use Application\Showcase\Stats\StatsFactory;
use Pongho\DependencyInjection\Container;
use Pongho\DependencyInjection\ServiceProviderInterface;

class StatsServiceProvider implements ServiceProviderInterface
{
    public function register(Container $container): void
    {
        $container->share(
            'showcase_stats_panels_manager',
            function (Container $container): PanelsManager {
                $panels_manager = new PanelsManager(
                    true,
                    $container->getParameter('path'),
                    $container->get('pongho_url'),
                );

                /** @var \Application\Core\User $user */
                $user = $container->get('current_user');

                if ($user->hasPermit('shop.admin.stats.sold')) {
                    $panels_manager->add($container->get('showcase_stats_sold_panel'));
                }

                if ($user->hasPermit('shop.admin.stats.ordered')) {
                    $panels_manager->add($container->get('showcase_stats_ordered_panel'));
                }

                return $panels_manager;
            },
        );

        $container->share(
            'showcase_stats_sold_panel',
            function (Container $container): PanelWidgetsCollection {
                /** @var \Application\Core\I18n\Translation\Translator $translator */
                $translator = $container->get('translator');

                return new PanelWidgetsCollection(
                    'sold',
                    $translator->trans('Sold'),
                    $container->get('showcase_stats_sold_widgets_collection'),
                );
            },
        );

        $container->share(
            'showcase_stats_sold_widgets_collection',
            function (Container $container): WidgetsCollection {
                /** @var \Application\Core\Model\LanguageSite $language_site */
                $language_site = $container->get('language_site');

                $coll = new WidgetsCollection();

                $widgetStatsFactory = new StatsFactory(
                    $container->get('translator'),
                    $container->get('widget_google_chart_factory'),
                );

                $coll->add($widgetStatsFactory->createLastMonthSold());
                $coll->add($widgetStatsFactory->createLastQuarterSold());
                $coll->add($widgetStatsFactory->createLastHalfYearSold());
                $coll->add($widgetStatsFactory->createLastYearSold());
                $coll->add($widgetStatsFactory->createLastMonthTopSoldProducts($language_site->language_id));
                $coll->add($widgetStatsFactory->createLastYearTopSoldProducts($language_site->language_id));

                return $coll;
            },
        );

        $container->share(
            'showcase_stats_ordered_panel',
            function (Container $container): PanelWidgetsCollection {
                /** @var \Application\Core\I18n\Translation\Translator $translator */
                $translator = $container->get('translator');

                return new PanelWidgetsCollection(
                    'ordered',
                    $translator->trans('Ordered'),
                    $container->get('showcase_stats_ordered_widgets_collection'),
                );
            },
        );

        $container->share(
            'showcase_stats_ordered_widgets_collection',
            function (Container $container): WidgetsCollection {
                /** @var \Application\Core\Model\LanguageSite $language_site */
                $language_site = $container->get('language_site');

                $coll = new WidgetsCollection();

                $widgetStatsFactory = new StatsFactory(
                    $container->get('translator'),
                    $container->get('widget_google_chart_factory'),
                );

                $coll->add($widgetStatsFactory->createLastMonthOrdered());
                $coll->add($widgetStatsFactory->createLastQuarterOrdered());
                $coll->add($widgetStatsFactory->createLastHalfYearOrdered());
                $coll->add($widgetStatsFactory->createLastYearOrdered());
                $coll->add($widgetStatsFactory->createLastMonthTopOrderedProducts($language_site->language_id));
                $coll->add($widgetStatsFactory->createLastYearTopOrderedProducts($language_site->language_id));

                return $coll;
            },
        );
    }
}
