<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Showcase
 */

namespace Application\Showcase\DependencyInjection;

use Application\Showcase\GoogleShopping\FeedProvider;
use Application\Showcase\GoogleShopping\Form\NodeFormConfigFilter;
use Application\Showcase\GoogleShopping\Form\TermFormConfigFilter;
use Application\Showcase\GoogleShopping\Translator;
use Application\Showcase\Model\Manager\GoogleShoppingProductManager;
use Pongho\DependencyInjection\Container;
use Pongho\DependencyInjection\ServiceProviderInterface;
use Pongho\Sdk\GoogleShopping\FeedGenerator;
use Pongho\Sdk\GoogleShopping\ProductValidator;

class GoogleShoppingServiceProvider implements ServiceProviderInterface
{
    public function register(Container $container): void
    {
        $container->share(
            'google_shopping_product_manager',
            function (Container $container): GoogleShoppingProductManager {
                return new GoogleShoppingProductManager(
                    $container->get('connection'),
                    $container->get('language_site'),
                );
            },
        );

        $container->share(
            'google_shopping_product_validator',
            function (Container $container): ProductValidator {
                return new ProductValidator(
                    $container->get('google_shopping_translator'),
                );
            },
        );

        $container->share(
            'google_shopping_feed_provider',
            function (Container $container): FeedProvider {
                return new FeedProvider(
                    $container->get('google_shopping_product_manager'),
                    $container->get('site'),
                );
            },
        );

        $container->share(
            'google_shopping_feed_generator',
            function (Container $container): FeedGenerator {
                return new FeedGenerator(
                    $container->get('google_shopping_feed_provider'),
                    $container->get('google_shopping_product_validator'),
                );
            },
        );

        $container->share(
            'google_shopping_translator',
            function (Container $container): Translator {
                return new Translator(
                    $container->get('translator'),
                );
            },
        );

        $container->share(
            'google_shopping_node_form_config_filter',
            function (Container $container): NodeFormConfigFilter {
                return new NodeFormConfigFilter(
                    $container->get('translator'),
                    $container->get('admin.template_head'),
                );
            },
        );

        $container->share(
            'google_shopping_term_form_config_filter',
            function (Container $container): TermFormConfigFilter {
                return new TermFormConfigFilter(
                    $container->get('translator'),
                    $container->get('admin.template_head'),
                );
            },
        );
    }
}
