<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Showcase
 */

namespace Application\Showcase\Controller\Admin;

use Application\Admin\Controller\StatsController as BaseStatsController;
use Pongho\Http\Exception\HttpUnauthorizedException;

class StatsController extends BaseStatsController
{
    /**
     * {@inheritdoc}
     *
     * TODO: Valutare se questo metodo serve...
     */
    protected function boot()
    {
        parent::boot();

        // Potrei aver impostato la risposta con il redirect alla pagina di login.
        if ($this->response) {
            return;
        }

        // Permesso consentito?
        if (!$this->getHelper()->getUser()->hasPermit('shop.admin.stats')) {
            throw new HttpUnauthorizedException();
        }
    }

    /**
     * @return null|\Pongho\Http\Response
     */
    public function indexAction()
    {
        return $this->view();
    }

    /**
     * {@inheritdoc}
     */
    protected function getTitle()
    {
        return $this->getHelper()->getTranslator()->trans('Stats');
    }

    /**
     * {@inheritdoc}
     */
    protected function getPanelsManager()
    {
        return $this->getContainer()->get('showcase_stats_panels_manager');
    }
}
