<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Showcase
 */

namespace Application\Showcase\Controller\Admin;

use Application\Admin\Controller\AdminController;
use Application\Cms\Model\Manager\NodeTypeManager;
use Application\Showcase\Installer\NodeTypeConverter;
use Pongho\Http\Exception\HttpNotFoundException;
use Pongho\Http\RedirectResponse;
use Pongho\Utilities\Inflector;

class NodeTypeConverterController extends AdminController
{
    /**
     * @return RedirectResponse
     */
    public function convertAction()
    {
        /**
         * @var NodeTypeConverter $converter
         * @var NodeTypeManager   $manager
         */
        $converter = $this->getContainer()->get('showcase_node_type_converter');
        $manager = $this->getContainer()->get('node_type_manager');

        try {
            $node_type = $manager->findNodeTypeByModuleId($this->getModuleId(), $this->getHelper()->getLanguageId());
        } catch (\Exception) {
            throw new HttpNotFoundException();
        }

        $converter->convert($node_type);

        $redirect = '/' . Inflector::pluralize($node_type->node_type) . '-options/';

        return new RedirectResponse($this->url($redirect));
    }

    /**
     * @return RedirectResponse
     */
    public function convert_to_baseAction()
    {
        /**
         * @var NodeTypeConverter $converter
         * @var NodeTypeManager   $manager
         */
        $converter = $this->getContainer()->get('showcase_node_type_converter');
        $manager = $this->getContainer()->get('node_type_manager');

        try {
            $node_type = $manager->findNodeTypeByModuleId($this->getModuleId(), $this->getHelper()->getLanguageId());
        } catch (\Exception) {
            throw new HttpNotFoundException();
        }

        $converter->convertToBase($node_type);

        $redirect = '/' . Inflector::pluralize($node_type->node_type) . '-options/';

        return new RedirectResponse($this->url($redirect));
    }
}
