<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author  Daniele Termini
 * @package Application\Core
 */

namespace Application\Core\Utilities;

require PONGHO_PATH . '/vendor/xlsreader/reader.php';

/**
 * Class XlsReader
 *
 * Wrapper al componente per il caricamento di un foglio excel
 */
class XlsReader
{
    protected $filename;

    protected $rows = [];

    /**
     * Costruttore.
     *
     * Elabora il file passato caricandone il contenuto in una tabella
     *
     * @param string $filename
     */
    public function __construct($filename)
    {
        if (!file_exists($filename)) {
            throw new \InvalidArgumentException(sprintf('File %s not exists!', $filename));
        }

        $this->filename = $filename;
    }

    /**
     * Esegue il caricamento di un foglio
     *
     * @param int $sheet numero del foglio da caricare, base 0
     * @return array
     * @throws \Exception
     */
    public function readSheet($sheet = 0)
    {
        $excel = new \Spreadsheet_Excel_Reader();
        $excel->setUTFEncoder('mb');
        $excel->setOutputEncoding('UTF-8');
        $excel->read($this->filename);

        if ($excel->sheets[$sheet]['numRows'] !== count($excel->sheets[$sheet]['cells'])) {
            throw new \Exception('Please verify your xls file, delete any empty row on the bottom which could have formats applied');
        }

        $x = 1;
        while ($x <= $excel->sheets[$sheet]['numRows']) {
            $this->rows[$sheet][$x] = $excel->sheets[$sheet]['cells'][$x];

            $x++;
        }

        return $this->rows;
    }
}
