<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Utilities;

use Application\Core\Entity\AccountInterface;

class UserActivationLinkBuilder
{
    /**
     * @param bool             $reset
     * @return string
     */
    public function build(AccountInterface $account, $reset = true)
    {
        if ($reset) {
            /**
             * @var \Application\Core\Model\Account $account
             *
             * @todo AccountManager
             */
            $account->resetActivationKey()->save();
        }

        $query = [
            'u'   => $account->getId(),
            'key' => $account->getActivationKey(),
        ];

        return absolute_url('/user/activation/?' . http_build_query($query, '', '&amp;'));
    }
}
