<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Utilities;

use Doctrine\DBAL\Connection;

/**
 * ChangeDomainManagerFactory
 */
class ChangeDomainHandlerFactory
{
    /**
     * @var Connection
     */
    private $connection;

    public function __construct(Connection $connection)
    {
        $this->connection = $connection;
    }

    /**
     * @return ChangeDomainHandler
     */
    public function create()
    {
        $handler = new ChangeDomainHandler();

        $handler->registerQuery(function ($oldDomain, $newDomain): void {
            $qb = $this->connection->createQueryBuilder();

            $qb
                ->update('pongho_sites')
                ->set('domain', 'REPLACE(domain, :old, :new)')
                ->set('images_url', 'REPLACE(images_url, :old, :new)')
                ->set('uploads_url', 'REPLACE(uploads_url, :old, :new)')
                ->set('themes_url', 'REPLACE(themes_url, :old, :new)')
                ->setParameter('old', $oldDomain)
                ->setParameter('new', $newDomain)
            ;

            $qb->executeStatement();
        });

        return $handler;
    }
}
