<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author Daniele De Nobili
 * @package Foo
 */

namespace Application\Core\Utilities;

/**
 * Permette di renderizzare un indirizzo.
 *
 * @deprecated
 */
class AddressRenderer
{
    /**
     * Template da utilizzare per il rendering.
     *
     * @var string
     */
    protected $template;

    /**
     * @param string $template
     */
    public function __construct($template)
    {
        $this->template = $template;
    }

    /**
     * Renderizza l’indirizzo passato.
     *
     * L’indirizzo è un elenco di campi:
     *
     * - name
     * - surname
     * - address1
     * - address2
     * - city
     * - province
     * - postcode
     * - country
     *
     * @return string
     */
    public function render(array $address)
    {
        $vars = [];
        foreach ($address as $field => $value) {
            $vars['{' . $field . '}'] = $value;
        }

        $code = str_replace(array_keys($vars), array_values($vars), $this->template);
        $code = preg_replace('/[ \t]+/', ' ', $code);
        $code = preg_replace('/[\n\r]+/', "\n", (string) $code);

        return nl2br((string) $code);
    }
}
